#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "qcap.h"
#include "qcap.windef.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void HwInitialize();

    void HwUninitialize();

    void timerEvent( QTimerEvent *event );

public:
    Ui::MainWindow *ui;

    PVOID				m_pDevice[4];

    PVOID				m_hNetworkServer[4];

    volatile ULONG		m_nNetworkServerState_audio[4];

    CRITICAL_SECTION	m_hNetworkServerAccessCriticalSection_audio[4];

    volatile ULONG		m_nNetworkServerState_video[4];

    CRITICAL_SECTION	m_hNetworkServerAccessCriticalSection_video[4];

    ULONG				m_nVideoWidth[4];

    ULONG				m_nVideoHeight[4];

    BOOL				m_bVideoIsInterleaved[4];

    double				m_dVideoFrameRate[4];

    ULONG				m_nAudioChannels[4];

    ULONG				m_nAudioBitsPerSample[4];

    ULONG				m_nAudioSampleFrequency[4];

    QString             m_str_info[4];

    int                 m_nTimerId;

private slots:

    void on_pushBTN_Start_1_clicked();
    void on_pushBTN_Stop_1_clicked();
    void on_pushBTN_Start_2_clicked();
    void on_pushBTN_Stop_2_clicked();
    void on_pushBTN_Start_3_clicked();
    void on_pushBTN_Stop_3_clicked();
    void on_pushBTN_Start_4_clicked();
    void on_pushBTN_Stop_4_clicked();
};

#endif // MAINWINDOW_H
